/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License version 2 
    as published by the Free Software Foundation.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA


    Copyright (C) 2006  Thierry Berger-Perrin <tbptbp@gmail.com>
*/
#ifndef RT_KDTREE_H
#define RT_KDTREE_H

#include "rt_triangle_wald.h"
namespace kdtree {
    struct node_leaf_t {
        // 31 -> leaf, 30-0 -> offset of the start of the triangle list, 
        uint32_t    offset_flag;
        uint32_t    count;
    };
    struct node_inner_t {
        // 31 -> leaf, 30-3 -> positive offset to both children, 1-0 -> split axis
        uint32_t    dim_offset_flag;
        float32_t    split_coord;
    };

    union node_t {
        enum { 
            mask_leaf = 1ul<<31, mask_list = ~mask_leaf,
            mask_axis = 3ul, mask_children = ~mask_axis
        };

        node_leaf_t        leaf;
        node_inner_t    inner;

        FINLINE bool_t is_leaf() const { return leaf.offset_flag & mask_leaf; }
        FINLINE uint_t get_list() const { return leaf.offset_flag & mask_list; }
        FINLINE uint_t get_axis() const { return inner.dim_offset_flag & mask_axis; }
        FINLINE uint_t get_offset()    const { return inner.dim_offset_flag & mask_children; }
        FINLINE const node_t * __restrict get_children() const { return (const node_t * __restrict) ((const char * __restrict)this)[get_offset()]; }
    };

    typedef uint32_t tri_id_t;

    struct descriptor_t {
        const node_t * __restrict root;
        const tri_id_t * __restrict ids;
        const rt::wald_tri_t * __restrict acc;
        int node_n;
        int id_n;
        int tri_n;
    };
}



#endif
